<?php

namespace app\models\form;

use Yii;
use yii\base\Model;
use yii\db\ActiveRecord;
use app\models\User;


class DropGame extends Model
{
    public $password;

    private $_user = false;


   
    public function rules()
    {
        return [
            
            [['password'], 'required', 'message' => 'Необходимо ввести пароль'],
           
           
            ['password', 'validatePassword'],
        ];
    }
    
    
    public function attributeLabels()
	 {
		 
		 return 
		 [
		  'password' => 'Пароль',
		 ];
		 
	 }
 
 
    public function validatePassword($attribute, $params)
    {
        if (!$this->hasErrors()) {
            $user = $this->getUser();

          
            if (!$user || !Yii::$app->getSecurity()->validatePassword($this->password, $user->password)) {
                $this->addError($attribute, 'Неверный пароль.');
            }
                
        }
    }

  
  
    public function getUser()
    {
        if ($this->_user === false) {
            $this->_user = User::findOne(1);
        }

        return $this->_user;
    }
	
	
	
}
